/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.toy.lang.TVirtualMachine;
import edu.princeton.toy.lang.TWordBuffer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TSimStdoutPane
extends JPanel
implements Scrollable {
    private static final String CLASS_STRING = TSimStdoutPane.class.toString();
    public static final String RESCALE_COMMAND = CLASS_STRING + "#rescaleCommand";
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    public static final int MIN_SCALE = 2;
    public static final int MAX_SCALE = Integer.MAX_VALUE;
    public static final int PREFERRED_SCALE = 14;
    private static final int CACHE_SIZE = 100;
    private static final Integer[] INTEGERS = new Integer[100];
    private static final Font[] FONT_CACHE = new Font[100];
    private static final int ROW_COUNT = 16;
    private static final int ROWS_PER_BLOCK = 4;
    private static final int UNSCALED_MINIMUM_PAGE_WIDTH = 9;
    private static final int UNSCALED_PREFERRED_PAGE_WIDTH = 12;
    private static final int UNSCALED_HEIGHT = 21;
    private static final Dimension PREFERRED_SCROLLABLE_VIEWPORT_SIZE = new Dimension(168, 294);
    private static final Color SELECTED_CELL_BACKGROUND = new Color(204, 204, 255);
    private static final Border SELECTED_CELL_BORDER = new LineBorder(new Color(142, 142, 178), 1);
    private int columnCount;
    private int unscaledWidth;
    private int scale;
    private Rectangle whiteRectangle;
    TWordBuffer stdout;
    TWordBuffer oldStdout;
    private JLabel disabledCellRenderer;
    private JLabel unselectedCellRenderer;
    private JLabel selectedCellRenderer;
    private Listener listener;
    private TVirtualMachine virtualMachine;
    private int dragOffset;

    public TSimStdoutPane(TVirtualMachine virtualMachine) {
        this.setForeground(Color.black);
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        this.virtualMachine = virtualMachine;
        this.stdout = new TWordBuffer();
        this.oldStdout = new TWordBuffer();
        this.listener = new Listener();
        virtualMachine.addChangeListener(this.listener);
        this.disabledCellRenderer = new JLabel();
        this.disabledCellRenderer.setOpaque(false);
        this.disabledCellRenderer.setEnabled(false);
        this.disabledCellRenderer.setHorizontalAlignment(0);
        this.disabledCellRenderer.setVerticalAlignment(0);
        this.unselectedCellRenderer = new JLabel();
        this.unselectedCellRenderer.setOpaque(false);
        this.unselectedCellRenderer.setHorizontalAlignment(0);
        this.unselectedCellRenderer.setVerticalAlignment(0);
        this.selectedCellRenderer = new JLabel();
        this.selectedCellRenderer.setOpaque(true);
        this.selectedCellRenderer.setBackground(SELECTED_CELL_BACKGROUND);
        this.selectedCellRenderer.setBorder(SELECTED_CELL_BORDER);
        this.selectedCellRenderer.setHorizontalAlignment(0);
        this.selectedCellRenderer.setVerticalAlignment(0);
        this.scale = -1;
        this.whiteRectangle = new Rectangle();
        this.doCommand(RESCALE_COMMAND, INTEGERS[14]);
        this.setMinimumSize(new Dimension(2, 42));
        this.enableEvents(65585L);
    }

    public void setVirtualMachine(TVirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        if (this.virtualMachine == virtualMachine) {
            return;
        }
        this.virtualMachine.removeChangeListener(this.listener);
        virtualMachine.addChangeListener(this.listener);
        this.virtualMachine = virtualMachine;
        this.doCommand(UPDATE_COMMAND, Boolean.FALSE);
    }

    public TVirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == RESCALE_COMMAND) {
            Font font;
            int scale = (Integer)extraInfo;
            if (scale < 2 || scale > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            if (scale == this.scale) {
                this.repaint();
                return false;
            }
            if (scale >= 100) {
                font = new Font("Monospaced", 1, (int)(0.9 * (double)scale));
            } else {
                if (FONT_CACHE[scale] == null) {
                    TSimStdoutPane.FONT_CACHE[scale] = new Font("Monospaced", 1, (int)(0.9 * (double)scale));
                }
                font = FONT_CACHE[scale];
            }
            this.disabledCellRenderer.setFont(font);
            this.unselectedCellRenderer.setFont(font);
            this.selectedCellRenderer.setFont(font);
            Dimension preferredSize = this.getPreferredSize();
            preferredSize.width = (this.unscaledWidth + 2) * scale;
            this.setPreferredSize(preferredSize);
            this.scale = scale;
            this.repaint();
            return true;
        }
        if (command == UPDATE_COMMAND) {
            TWordBuffer tempBuffer = this.oldStdout;
            this.oldStdout = this.stdout;
            this.stdout = tempBuffer;
            this.virtualMachine.getStdout(this.stdout);
            int columnCount = Math.max(2, (this.stdout.getSize() + 16 - 1) / 16);
            if (this.columnCount != columnCount) {
                this.columnCount = columnCount;
                this.unscaledWidth = columnCount * 5 + 1;
                this.whiteRectangle.width = this.scale * this.unscaledWidth;
                Dimension preferredSize = this.getPreferredSize();
                preferredSize.width = (this.unscaledWidth + 2) * this.scale;
                this.setPreferredSize(preferredSize);
                this.revalidate();
            }
            if (!this.stdout.equals(this.oldStdout)) {
                if (extraInfo != null && ((Boolean)extraInfo).booleanValue()) {
                    this.scrollToFrontier();
                } else {
                    this.repaint();
                }
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int scale = this.scale;
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        int yOffset = this.whiteRectangle.y;
        int xOffset = this.whiteRectangle.x;
        g.setColor(Color.white);
        g.fillRect(xOffset, yOffset, this.whiteRectangle.width, this.whiteRectangle.height);
        g.setColor(Color.black);
        g.drawRect(xOffset, yOffset, this.whiteRectangle.width, this.whiteRectangle.height);
        int columnStart = Math.max(0, ((clip.x - xOffset) / scale - 1) / 5);
        int columnEnd = Math.min(this.columnCount - 1, ((clip.x + clip.width - xOffset) / scale - 1) / 5);
        Color foreground = this.getForeground();
        this.selectedCellRenderer.setForeground(foreground);
        this.unselectedCellRenderer.setForeground(foreground);
        this.unselectedCellRenderer.setBackground(this.getBackground());
        this.disabledCellRenderer.setBackground(Color.white);
        this.disabledCellRenderer.setBounds(0, 0, 4 * scale, scale);
        this.selectedCellRenderer.setBounds(0, 0, 4 * scale, scale);
        this.unselectedCellRenderer.setBounds(0, 0, 4 * scale, scale);
        int previousOriginX = 0;
        int previousOriginY = 0;
        int stdoutSize = this.stdout.getSize();
        for (int colCtr = columnStart; colCtr <= columnEnd; ++colCtr) {
            for (int rowCtr = 0; rowCtr < 16; ++rowCtr) {
                int currentOriginY;
                int currentOriginX;
                int index = colCtr * 16 + rowCtr;
                if (index < stdoutSize) {
                    currentOriginX = (1 + colCtr * 5) * scale + xOffset;
                    currentOriginY = (1 + rowCtr / 4 + rowCtr) * scale + yOffset;
                    g.translate(currentOriginX - previousOriginX, currentOriginY - previousOriginY);
                    if (index == stdoutSize - 1) {
                        this.selectedCellRenderer.setText(this.stdout.getWord(index).toHexString(false));
                        this.selectedCellRenderer.paint(g);
                    } else {
                        this.unselectedCellRenderer.setText(this.stdout.getWord(index).toHexString(false));
                        this.unselectedCellRenderer.paint(g);
                    }
                    previousOriginX = currentOriginX;
                    previousOriginY = currentOriginY;
                    continue;
                }
                currentOriginX = (1 + colCtr * 5) * scale + xOffset;
                currentOriginY = (1 + rowCtr / 4 + rowCtr) * scale + yOffset;
                g.translate(currentOriginX - previousOriginX, currentOriginY - previousOriginY);
                this.disabledCellRenderer.setText("-");
                this.disabledCellRenderer.paint(g);
                previousOriginX = currentOriginX;
                previousOriginY = currentOriginY;
            }
        }
        g.translate(-previousOriginX, -previousOriginY);
    }

    @Override
    protected void processHierarchyBoundsEvent(HierarchyEvent e) {
        if (e.getID() == 1402 && e.getChanged() == this.getParent() && e.getChanged() instanceof JViewport) {
            this.deriveScale();
        }
    }

    @Override
    protected void processComponentEvent(ComponentEvent e) {
        if (e.getID() == 101) {
            this.deriveScale();
        }
        super.processComponentEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        Container parent;
        if (e.getID() == 501 && (e.getModifiers() & 0x10) != 0 && (parent = this.getParent()) instanceof JViewport) {
            this.dragOffset = e.getX() + this.getX() + ((JViewport)parent).getViewPosition().x;
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        Container parent;
        if (e.getID() == 506 && (e.getModifiers() & 0x10) != 0 && (parent = this.getParent()) instanceof JViewport) {
            int paneWidth;
            JViewport viewport = (JViewport)parent;
            Rectangle rectangle = viewport.getViewRect();
            int newPosition = this.dragOffset - (e.getX() + this.getX());
            if (newPosition + rectangle.width > (paneWidth = this.getPreferredSize().width)) {
                newPosition = paneWidth - rectangle.width;
            }
            if (newPosition < 0) {
                newPosition = 0;
            }
            viewport.setViewPosition(new Point(newPosition, rectangle.y));
        }
        super.processMouseEvent(e);
    }

    private void deriveScale() {
        int height = this.getHeight();
        int scale = height / 21;
        if (this.getParent() instanceof JViewport) {
            int width = ((JViewport)this.getParent()).getWidth();
            scale = Math.min(scale, width / 9);
        }
        if (scale < 2) {
            scale = 2;
        }
        if (scale > Integer.MAX_VALUE) {
            scale = Integer.MAX_VALUE;
        }
        this.whiteRectangle.x = scale;
        this.whiteRectangle.y = height / 2 - 21 * scale / 2;
        this.whiteRectangle.width = scale * this.unscaledWidth;
        this.whiteRectangle.height = scale * 21;
        if (scale >= 100) {
            this.doCommand(RESCALE_COMMAND, new Integer(scale));
        } else {
            this.doCommand(RESCALE_COMMAND, INTEGERS[scale]);
        }
    }

    public void scrollToFrontier() {
        int selectedColumn = (this.stdout.getSize() - 1) / 16;
        this.scrollRectToVisible(new Rectangle(selectedColumn * 6 * this.scale + this.whiteRectangle.x, 0, 7 * this.scale, this.getHeight()));
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return PREFERRED_SCROLLABLE_VIEWPORT_SIZE;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height / 10;
            }
            case 0: {
                return visibleRect.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height;
            }
            case 0: {
                return visibleRect.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    static {
        for (int ctr = 0; ctr < 100; ++ctr) {
            TSimStdoutPane.INTEGERS[ctr] = new Integer(ctr);
        }
    }

    protected class Listener
    implements ChangeListener {
        protected Listener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TSimStdoutPane.this.doCommand(UPDATE_COMMAND, Boolean.TRUE);
        }
    }
}

